<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class BankAccount extends Model 
{

    protected $table = 'bank_accounts';
    public $timestamps = true;
    protected $fillable = array('description', 'agency', 'number', 'wallet', 'bank_id', 'benefeciary_id', 'title');
    protected $visible = array('description', 'agency', 'number', 'wallet', 'bank_id', 'benefeciary_id', 'title');

    public function bank()
    {
        return $this->belongsTo('Bank', 'bank_id');
    }

    public function beneficiary()
    {
        return $this->belongsTo('Beneficiary');
    }

}